package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.kotlinassertions.ForbiddenMethodsChecker
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.provider.MapProperty
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.TaskAction

abstract class MethodsCheck : DefaultTask() {
    @get:InputFile
    abstract val aarFile: RegularFileProperty

    @get:Input
    abstract val forbiddenMethods: MapProperty<String, List<String>>

    @TaskAction
    fun check() {
        logger.info("Check forbidden methods in ${aarFile.get()}")
        ForbiddenMethodsChecker.check(
            aarFile.get().asFile,
            forbiddenMethods.get()
        )
    }
}
