package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.manifest.ManifestExtractor
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

abstract class ManifestDump : DefaultTask() {
    @get:InputFile
    abstract val aarFile: RegularFileProperty

    @get:OutputFile
    abstract val manifestDumpFile: RegularFileProperty

    @TaskAction
    fun dump() {
        logger.info("Dump manifest for ${aarFile.get()}")
        ManifestExtractor.extractToFile(
            aarFile.get().asFile,
            manifestDumpFile.get().asFile,
            asTemplate = true
        )
    }
}
