package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.manifest.ManifestChecker
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.Optional
import org.gradle.api.tasks.TaskAction

abstract class ManifestCheck : DefaultTask() {
    @get:InputFile
    abstract val aarFile: RegularFileProperty

    @get:Input
    @get:Optional
    abstract val versionCode: Property<String>

    @get:InputFile
    abstract val manifestDumpFile: RegularFileProperty

    @TaskAction
    fun check() {
        logger.info("Check manifest for ${aarFile.get()}")
        ManifestChecker(
            fullCheck = true,
            versionCode = versionCode.orNull
        ).check(aarFile.get().asFile, manifestDumpFile.get().asFile)
    }
}
