package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.imports.ImportChecker
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.provider.ListProperty
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.TaskAction

abstract class ImportsCheck : DefaultTask() {
    @get:InputFile
    abstract val aarFile: RegularFileProperty

    @get:Input
    abstract val forbiddenImports: ListProperty<String>

    @TaskAction
    fun check() {
        logger.info("Check forbidden imports in ${aarFile.get()}")
        ImportChecker.check(
            aarFile.get().asFile,
            forbiddenImports.get()
        )
    }
}
