package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.agp.AndroidLibraryVariant
import io.appmetrica.gradle.aarcheck.dependencies.DependenciesExtractor
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Internal
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

abstract class DependenciesDump : DefaultTask() {
    @get:Internal
    abstract val androidLibraryVariant: Property<AndroidLibraryVariant>

    @get:OutputFile
    abstract val dependenciesDumpFile: RegularFileProperty

    @TaskAction
    fun dump() {
        logger.info("Dump dependencies for ${androidLibraryVariant.get().name}")

        dependenciesDumpFile.get().asFile.writeText(
            DependenciesExtractor.extract(androidLibraryVariant.get())
        )
    }
}
