package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.api.ApiGenerator
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.Optional
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

abstract class ApiDump : DefaultTask() {
    @get:InputFile
    abstract val aarFile: RegularFileProperty

    @get:InputFile
    @get:Optional
    abstract val mappingFile: RegularFileProperty

    @get:OutputFile
    abstract val apiDumpFile: RegularFileProperty

    @TaskAction
    fun dump() {
        logger.info("Dump api for ${aarFile.get()}")
        ApiGenerator.generateTo(
            aarFile.get().asFile,
            apiDumpFile.get().asFile,
            mappingFile.orNull?.asFile
        )
    }
}
