package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.api.ApiChecker
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.Optional
import org.gradle.api.tasks.TaskAction

abstract class ApiCheck : DefaultTask() {
    @get:InputFile
    abstract val aarFile: RegularFileProperty

    @get:InputFile
    @get:Optional
    abstract val mappingFile: RegularFileProperty

    @get:InputFile
    abstract val apiDumpFile: RegularFileProperty

    @get:Input
    @get:Optional
    abstract val packageName: Property<String>

    @TaskAction
    fun check() {
        logger.info("Check api for ${aarFile.get()}")
        ApiChecker.checkPackage(
            aarFile.get().asFile,
            packageName.orNull
        )
        ApiChecker.check(
            aarFile.get().asFile,
            apiDumpFile.get().asFile,
            mappingFile.orNull?.asFile
        )
    }
}
