package io.appmetrica.gradle.aarcheck.proguard

import io.appmetrica.gradle.aarcheck.AarCheckException
import io.appmetrica.gradle.aarcheck.AarCheckPlugin
import io.appmetrica.gradle.aarcheck.utils.DiffUtils
import org.slf4j.LoggerFactory
import java.io.File

class ProguardChecker {
    private val logger = LoggerFactory.getLogger(AarCheckPlugin.PLUGIN_NAME)

    fun check(aarFile: File, proguardDumpFile: File) {
        if (!proguardDumpFile.exists()) {
            throw AarCheckException(
                "Proguard check failed. Not found file ${proguardDumpFile.canonicalPath}. " +
                    "You can run :proguardDump task to generate proguard dump"
            )
        }

        val proguardDump = proguardDumpFile.readText()
        val proguard = ProguardExtractor.extract(aarFile)
        val diff = DiffUtils.diff(proguardDump, proguard, "dump proguard", "cur proguard")
        if (diff != null) {
            logger.error("Diff:\n$diff")
            throw AarCheckException(
                "Proguard check failed. See diff above. " +
                    "You can run :proguardDump task to overwrite proguard dump"
            )
        }
    }
}
