package io.appmetrica.gradle.aarcheck.pom

import io.appmetrica.gradle.aarcheck.AarCheckException
import io.appmetrica.gradle.aarcheck.AarCheckPlugin
import io.appmetrica.gradle.aarcheck.utils.DiffUtils
import org.slf4j.LoggerFactory
import java.io.File

object PomChecker {
    private val logger = LoggerFactory.getLogger(AarCheckPlugin.PLUGIN_NAME)

    fun check(dumpFile: File, pomFile: File) {
        if (!dumpFile.exists()) {
            throw AarCheckException(
                "Pom check failed. Not found file ${dumpFile.canonicalPath}. " +
                    "You can run :pomDump task to generate pom dump"
            )
        }

        val dump = dumpFile.readText()
        val pom = pomFile.readText()
        val diff = DiffUtils.diff(dump, pom, "dump pom", "cur pom")
        if (diff != null) {
            logger.error("Diff:\n$diff")
            throw AarCheckException(
                "Pom check failed. See diff above. " +
                    "You can run :pomDump task to overwrite pom dump"
            )
        }
    }
}
