package io.appmetrica.gradle.aarcheck.module

import groovy.json.JsonBuilder
import groovy.json.JsonSlurper

object ModuleNormalizer {
    fun normalize(module: String): String {
        val json = JsonSlurper().parseText(module) as Map<*, *>
        json.getMap("createdBy").getMap("gradle")["buildId"] = "<random-string>"
        json.getList("variants").forEach { variant ->
            variant.getList("files").forEach { file ->
                file["size"] = -1
                file["sha512"] = "<sha512>"
                file["sha256"] = "<sha256>"
                file["sha1"] = "<sha1>"
                file["md5"] = "<md5>"
            }
        }
        return JsonBuilder(json).toPrettyString() + "\n"
    }

    @Suppress("UNCHECKED_CAST")
    private fun Map<*, *>.getMap(key: String): MutableMap<String, Any> =
        this[key] as MutableMap<String, Any>

    @Suppress("UNCHECKED_CAST")
    private fun Map<*, *>.getList(key: String): List<MutableMap<String, Any>> =
        this[key] as List<MutableMap<String, Any>>
}
