package io.appmetrica.gradle.aarcheck.module

import io.appmetrica.gradle.aarcheck.AarCheckException
import io.appmetrica.gradle.aarcheck.AarCheckPlugin
import io.appmetrica.gradle.aarcheck.utils.DiffUtils
import org.slf4j.LoggerFactory
import java.io.File

object ModuleChecker {
    private val logger = LoggerFactory.getLogger(AarCheckPlugin.PLUGIN_NAME)

    fun check(dumpFile: File, moduleFile: File) {
        if (!dumpFile.exists()) {
            throw AarCheckException(
                "Module check failed. Not found file ${dumpFile.canonicalPath}. " +
                    "You can run :moduleDump task to generate module dump"
            )
        }

        val dump = dumpFile.readText()
        val module = moduleFile.readText()
        val diff = DiffUtils.diff(dump, ModuleNormalizer.normalize(module), "dump module", "cur module")
        if (diff != null) {
            logger.error("Diff:\n$diff")
            throw AarCheckException(
                "Module check failed. See diff above. " +
                    "You can run :moduleDump task to overwrite module dump"
            )
        }
    }
}
