package io.appmetrica.gradle.aarcheck.manifest

import io.appmetrica.gradle.aarcheck.utils.readFile
import org.apache.tools.ant.filters.ReplaceTokens
import java.io.File
import java.util.zip.ZipFile

object ManifestExtractor {
    const val VERSION_CODE_TOKEN = "version_code"

    fun extractToFile(aarFile: File, manifestDumpFile: File, asTemplate: Boolean = false) {
        manifestDumpFile.writeText(extract(aarFile, asTemplate))
    }

    fun extract(aarFile: File, asTemplate: Boolean = false): String {
        ZipFile(aarFile).use { zipFile ->
            var manifest = zipFile.readFile("AndroidManifest.xml")

            if (asTemplate) {
                manifest = manifest
                    .replace("android:versionCode=\"\\d+\"".toRegex(), "android:versionCode=\"<$VERSION_CODE_TOKEN>\"")
            }

            return manifest
        }
    }

    fun fromTemplate(file: File, params: Map<String, String>): String {
        return file.reader().use {
            ReplaceTokens(it).apply {
                setBeginToken("<")
                setEndToken(">")
                for ((key, value) in params) {
                    addConfiguredToken(
                        ReplaceTokens.Token().apply {
                            setKey(key)
                            setValue(value)
                        }
                    )
                }
            }.readText()
        }
    }
}
