package io.appmetrica.gradle.aarcheck.api.parser.javassist

import io.appmetrica.gradle.aarcheck.api.AccessModifier
import javassist.Modifier

object Utils {
    fun getAccessModifier(modifiers: Int) = when {
        Modifier.isPublic(modifiers) -> AccessModifier.PUBLIC
        Modifier.isProtected(modifiers) -> AccessModifier.PROTECTED
        Modifier.isPackage(modifiers) -> AccessModifier.PACKAGE
        Modifier.isPrivate(modifiers) -> AccessModifier.PRIVATE
        else -> AccessModifier.PACKAGE
    }
}
