package io.appmetrica.gradle.aarcheck.api.parser.javassist

import io.appmetrica.gradle.aarcheck.api.TypeParameter
import javassist.bytecode.SignatureAttribute

object JavassistTypeParameter {
    fun from(type: SignatureAttribute.TypeParameter): TypeParameter {
        return TypeParameter(
            name = type.name,
            extend = type.classBound?.let(JavassistType::from) ?: JavassistType.OBJECT,
            interfaces = type.interfaceBound.map { JavassistType.from(it) }
        )
    }
}
