package io.appmetrica.gradle.aarcheck.api.parser.javassist

import io.appmetrica.gradle.aarcheck.api.Type
import io.appmetrica.gradle.aarcheck.api.TypeArgument
import javassist.bytecode.SignatureAttribute

object JavassistType {
    val OBJECT = from("java.lang.Object")

    private fun createType(fullName: String, arguments: List<TypeArgument>, arrayDim: Int = 0): Type {
        return Type(
            packageName = fullName.substringBeforeLast(".", "").takeUnless { it == "" },
            name = fullName.substringAfterLast("."),
            arguments = arguments,
            arrayDim = arrayDim
        )
    }

    fun from(type: String): Type = createType(type, emptyList())

    fun from(type: SignatureAttribute.ClassType): Type {
        return createType(
            fullName = type.jvmTypeName().substringBefore("<"),
            arguments = type.typeArguments?.map(JavassistTypeArgument::from) ?: emptyList()
        )
    }

    fun from(type: SignatureAttribute.ArrayType): Type {
        val componentType = from(type.componentType)
        return Type(
            packageName = componentType.packageName,
            name = componentType.name,
            arguments = componentType.arguments,
            arrayDim = type.dimension
        )
    }

    fun from(type: SignatureAttribute.Type): Type {
        return when (type) {
            is SignatureAttribute.ClassType -> from(type)
            is SignatureAttribute.ArrayType -> from(type)
            else -> createType(
                fullName = type.jvmTypeName(),
                arguments = emptyList()
            )
        }
    }
}
