package io.appmetrica.gradle.aarcheck.api.parser.javassist

import io.appmetrica.gradle.aarcheck.api.Class
import io.appmetrica.gradle.aarcheck.api.parser.Parser
import io.appmetrica.gradle.aarcheck.utils.NamesUtils
import io.appmetrica.gradle.aarcheck.utils.isClass
import javassist.ClassPool
import java.util.jar.JarFile
import kotlin.streams.toList

class JavassistParser : Parser() {
    override fun parseJar(jarFile: JarFile): List<Class> {
        val classPool = ClassPool()
        classPool.appendClassPath(jarFile.name)

        return jarFile.stream().filter { it.isClass() }.map { jarEntry ->
            val ctClass = classPool.get(NamesUtils.getFullClassName(jarEntry.name))
            JavassistClass.from(ctClass)
        }.toList()
    }
}
