package io.appmetrica.gradle.aarcheck.api.parser.javassist

import io.appmetrica.gradle.aarcheck.api.Class
import io.appmetrica.gradle.aarcheck.api.Method
import javassist.CtBehavior
import javassist.Modifier
import javassist.bytecode.AccessFlag
import javassist.bytecode.AnnotationsAttribute
import javassist.bytecode.MethodInfo
import javassist.bytecode.SignatureAttribute

object JavassistMethod {
    fun from(clazz: Class, ctBehavior: CtBehavior): Method {
        val signature = SignatureAttribute.toMethodSignature(ctBehavior.genericSignature ?: ctBehavior.signature)
        return Method(
            declaringClass = clazz,
            modifier = Utils.getAccessModifier(ctBehavior.modifiers),
            genericParameters = signature.typeParameters.map(JavassistTypeParameter::from),
            returnType = JavassistType.from(signature.returnType),
            name = when {
                ctBehavior.methodInfo.isStaticInitializer -> MethodInfo.nameClinit
                ctBehavior.methodInfo.isConstructor -> MethodInfo.nameInit
                else -> ctBehavior.name
            },
            params = JavassistMethodParams.from(ctBehavior),
            annotations = listOfNotNull(
                ctBehavior.methodInfo2.getAttribute(AnnotationsAttribute.invisibleTag) as AnnotationsAttribute?,
                ctBehavior.methodInfo2.getAttribute(AnnotationsAttribute.visibleTag) as AnnotationsAttribute?
            ).flatMap { it.annotations.map(JavassistAnnotation::from) },

            isConstructor = ctBehavior.methodInfo.isConstructor,
            isSynthetic = (ctBehavior.modifiers and AccessFlag.SYNTHETIC) != 0,
            isAbstract = Modifier.isAbstract(ctBehavior.modifiers),
            isStatic = Modifier.isStatic(ctBehavior.modifiers),
            isFinal = Modifier.isFinal(ctBehavior.modifiers),

            nativeSignature = ctBehavior.genericSignature ?: ctBehavior.signature
        )
    }
}
