package io.appmetrica.gradle.aarcheck.api.parser.javassist

import io.appmetrica.gradle.aarcheck.api.Class
import io.appmetrica.gradle.aarcheck.api.Field
import javassist.CtField
import javassist.Modifier
import javassist.bytecode.AccessFlag
import javassist.bytecode.AnnotationsAttribute
import javassist.bytecode.SignatureAttribute

object JavassistField {
    fun from(clazz: Class, ctField: CtField): Field {
        val signature = SignatureAttribute.toTypeSignature(ctField.genericSignature ?: ctField.signature)
        return Field(
            declaringClass = clazz,
            modifier = Utils.getAccessModifier(ctField.modifiers),
            type = JavassistType.from(signature),
            name = ctField.name,
            annotations = listOfNotNull(
                ctField.fieldInfo.getAttribute(AnnotationsAttribute.invisibleTag) as AnnotationsAttribute?,
                ctField.fieldInfo.getAttribute(AnnotationsAttribute.visibleTag) as AnnotationsAttribute?
            ).flatMap { it.annotations.map(JavassistAnnotation::from) },

            isSynthetic = (ctField.modifiers and AccessFlag.SYNTHETIC) != 0,
            isStatic = Modifier.isStatic(ctField.modifiers),
            isFinal = Modifier.isFinal(ctField.modifiers)
        )
    }
}
