package io.appmetrica.gradle.aarcheck.api.parser

import io.appmetrica.gradle.aarcheck.api.Class
import io.appmetrica.gradle.aarcheck.utils.extractEntry
import java.io.File
import java.util.jar.JarFile
import java.util.zip.ZipFile

abstract class Parser {
    abstract fun parseJar(jarFile: JarFile): List<Class>

    open fun parseJar(jarFile: File): List<Class> {
        return JarFile(jarFile).use(::parseJar)
    }

    open fun parseAar(aarFile: File): List<Class> {
        return ZipFile(aarFile).use { zipFile ->
            parseJar(zipFile.extractEntry("classes.jar"))
        }
    }
}
