package io.appmetrica.gradle.aarcheck.api

import io.appmetrica.gradle.aarcheck.utils.MappingFile

private const val OBFUSCATED_NAME_TEMPLATE = "OBFUSCATED[%s]"

class NameProvider(private val mappingFile: MappingFile?) {
    fun getClearClassName(type: Type): String {
        return mappingFile?.getClassName(type.fullName) ?: type.fullName
    }

    fun getClassName(type: Type): String {
        val name = getClearClassName(type)
        return if (name == type.fullName) {
            name
        } else {
            OBFUSCATED_NAME_TEMPLATE.format(name)
        }
    }

    fun getClearClassName(clazz: Class): String {
        return mappingFile?.getClassName(clazz.fullName) ?: clazz.fullName
    }

    fun getClassName(clazz: Class): String {
        val name = getClearClassName(clazz)
        return if (name == clazz.fullName) {
            name
        } else {
            OBFUSCATED_NAME_TEMPLATE.format(name)
        }
    }

    fun getClearFieldName(field: Field): String {
        val clearClassName = getClearClassName(field.declaringClass)
        return mappingFile?.getFieldName(clearClassName, field.name) ?: field.name
    }

    fun getFieldName(field: Field): String {
        val name = getClearFieldName(field)
        return if (name == field.name) {
            name
        } else {
            OBFUSCATED_NAME_TEMPLATE.format(name)
        }
    }

    fun getClearMethodName(method: Method): String {
        val className = getClearClassName(method.declaringClass)
        return mappingFile?.getMethodName(className, method.name, method.nativeSignature) ?: method.name
    }

    fun getMethodName(method: Method): String {
        val name = getClearMethodName(method)
        return if (name == method.name) {
            name
        } else {
            OBFUSCATED_NAME_TEMPLATE.format(name)
        }
    }
}
