package io.appmetrica.gradle.aarcheck.api

enum class AccessModifier {
    PUBLIC, PROTECTED, PRIVATE, PACKAGE;

    override fun toString() = name.toLowerCase()
}

enum class ClassType(private val value: String) {
    CLASS("class"),
    ENUM("enum"),
    INTERFACE("interface"),
    ANNOTATION("@interface");

    override fun toString() = value
}

data class TypeParameter(
    val name: String,
    val extend: Type,
    val interfaces: List<Type>
)

data class TypeArgument(
    val wildcard: Char,
    val type: Type?
)

data class Type(
    val packageName: String?,
    val name: String,
    val arguments: List<TypeArgument>,
    val arrayDim: Int
) {
    val fullName = "${packageName?.let { "$it." } ?: ""}$name"
}

data class Annotation(
    val type: Type
)

data class Class(
    val modifier: AccessModifier,
    val type: ClassType,
    val packageName: String?,
    val name: String,
    val genericParameters: List<TypeParameter>,
    val superClass: Type?,
    val interfaces: List<Type>,

    val isSynthetic: Boolean,
    val isAbstract: Boolean,
    val isStatic: Boolean,
    val isFinal: Boolean,

    val fields: List<Field>,
    val methods: List<Method>
) {
    val fullName = "${packageName?.let { "$it." } ?: ""}$name"
    val isAnonim = name.substringAfterLast("$").toIntOrNull() != null
}

data class Field(
    val declaringClass: Class,

    val modifier: AccessModifier,
    val type: Type,
    val name: String,
    val annotations: List<Annotation>,

    val isSynthetic: Boolean,
    val isStatic: Boolean,
    val isFinal: Boolean
)

data class MethodParam(
    val type: Type,
    val annotations: List<Annotation>,

    val isVarArgs: Boolean
)

data class Method(
    val declaringClass: Class,

    val modifier: AccessModifier,
    val genericParameters: List<TypeParameter>,
    val returnType: Type,
    val name: String,
    val params: List<MethodParam>,
    val annotations: List<Annotation>,

    val isConstructor: Boolean,
    val isSynthetic: Boolean,
    val isAbstract: Boolean,
    val isStatic: Boolean,
    val isFinal: Boolean,

    val nativeSignature: String
) {
    val paramString = params.joinToString(", ") { it.type.fullName }
    val fullName = "$name($paramString)"
}
