package io.appmetrica.gradle.aarcheck.agp

import com.android.build.api.variant.LibraryAndroidComponentsExtension
import com.android.build.gradle.LibraryExtension
import com.android.build.gradle.LibraryPlugin
import io.appmetrica.gradle.aarcheck.AarCheckBuildTypeExtension
import io.appmetrica.gradle.aarcheck.AarCheckFlavorExtension
import io.appmetrica.gradle.aarcheck.AarCheckPlugin
import org.gradle.api.Project
import org.gradle.kotlin.dsl.create
import org.gradle.kotlin.dsl.getByType

class AndroidPluginHelper(private val project: Project) {
    private val Project.androidLibraryExtension: LibraryExtension
        get() = project.extensions.getByType()

    private val Project.androidComponentsExtension: LibraryAndroidComponentsExtension
        get() = project.extensions.getByType()

    fun requirePlugin() {
        require(project.plugins.hasPlugin(LibraryPlugin::class.java)) {
            "Requires 'com.android.library' plugin"
        }
    }

    fun addExtensionsToDsl() {
        project.androidLibraryExtension.buildTypes.configureEach {
            extensions.create<AarCheckBuildTypeExtension>(AarCheckPlugin.EXTENSION_NAME)
        }
        project.androidLibraryExtension.productFlavors.configureEach {
            extensions.create<AarCheckFlavorExtension>(AarCheckPlugin.EXTENSION_NAME)
        }
    }

    fun configureEachVariant(block: (AndroidLibraryVariant) -> Unit) {
        project.androidComponentsExtension.onVariants { variant ->
            block(AndroidLibraryVariant(project, variant))
        }
    }

    fun getNamespace(): String? = project.androidLibraryExtension.namespace
}
