/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zookeeper.servicefinder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.NodeDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.util.FinderUtils;
import io.appform.ranger.zookeeper.common.ZkNodeDataStoreConnector;
import io.appform.ranger.zookeeper.common.ZkStoreType;
import io.appform.ranger.zookeeper.serde.ZkNodeDataDeserializer;
import io.appform.ranger.zookeeper.util.PathBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkNodeDataSource<T, D extends ZkNodeDataDeserializer<T>>
extends ZkNodeDataStoreConnector<T>
implements NodeDataSource<T, D> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkNodeDataSource.class);

    public ZkNodeDataSource(Service service, CuratorFramework curatorFramework) {
        super(service, curatorFramework, ZkStoreType.SOURCE);
    }

    public Optional<List<ServiceNode<T>>> refresh(D deserializer) {
        return this.checkForUpdateOnZookeeper(deserializer);
    }

    private Optional<List<ServiceNode<T>>> checkForUpdateOnZookeeper(D deserializer) {
        if (!this.isStarted()) {
            log.warn("Data source is not yet started for service: {}. No nodes will be returned.", (Object)this.service.getServiceName());
            return Optional.empty();
        }
        if (this.isStopped()) {
            log.warn("Data source is  stopped already for service: {}. No nodes will be returned.", (Object)this.service.getServiceName());
            return Optional.empty();
        }
        Preconditions.checkNotNull(deserializer, (Object)"Deserializer has not been set for node data");
        try {
            long healthcheckZombieCheckThresholdTime = this.healthcheckZombieCheckThresholdTime(this.service);
            String serviceName = this.service.getServiceName();
            if (!this.isActive()) {
                log.warn("ZK connection is not active. Ignoring refresh request for service: {}", (Object)this.service.getServiceName());
                return Optional.empty();
            }
            String parentPath = PathBuilder.servicePath(this.service);
            log.debug("Looking for node list of [{}]", (Object)serviceName);
            List children = (List)this.curatorFramework.getChildren().forPath(parentPath);
            ArrayList nodes = Lists.newArrayListWithCapacity((int)children.size());
            log.debug("Found {} nodes for [{}]", (Object)children.size(), (Object)serviceName);
            for (String child : children) {
                ServiceNode node;
                byte[] data = this.readChild(parentPath, child).orElse(null);
                if (data == null || data.length <= 0 || !FinderUtils.isValidNode((Service)this.service, (long)healthcheckZombieCheckThresholdTime, node = deserializer.deserialize(data))) continue;
                nodes.add(node);
            }
            return Optional.of(nodes);
        }
        catch (KeeperException.NoNodeException e) {
            log.error("No ZK container node found for service: {}. Will return empty list for now. Please doublecheck service name", (Object)this.service.getServiceName());
            return Optional.of(Collections.emptyList());
        }
        catch (Exception e) {
            log.error("Error getting service data from zookeeper: ", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<byte[]> readChild(String parentPath, String child) throws Exception {
        String path = String.format("%s/%s", parentPath, child);
        try {
            return Optional.ofNullable((byte[])this.curatorFramework.getData().forPath(path));
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("Node not found for path {}", (Object)path);
            return Optional.empty();
        }
        catch (KeeperException e) {
            log.error("Could not get data for node: " + path, (Throwable)e);
            return Optional.empty();
        }
    }
}

