/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zookeeper.serviceprovider;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.NodeDataSink;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.util.Exceptions;
import io.appform.ranger.zookeeper.common.ZkNodeDataStoreConnector;
import io.appform.ranger.zookeeper.common.ZkStoreType;
import io.appform.ranger.zookeeper.serde.ZkNodeDataSerializer;
import io.appform.ranger.zookeeper.util.PathBuilder;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkNodeDataSink<T, S extends ZkNodeDataSerializer<T>>
extends ZkNodeDataStoreConnector<T>
implements NodeDataSink<T, S> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkNodeDataSink.class);

    public ZkNodeDataSink(Service service, CuratorFramework curatorFramework) {
        super(service, curatorFramework, ZkStoreType.SINK);
    }

    public void updateState(S serializer, ServiceNode<T> serviceNode) {
        if (this.isStopped()) {
            log.warn("Node has been stopped already for service: {}. No update will be possible.", (Object)this.service.getServiceName());
            return;
        }
        Preconditions.checkNotNull(serializer, (Object)"Serializer has not been set for node data");
        String path = PathBuilder.instancePath(this.service, serviceNode);
        try {
            if (null == this.curatorFramework.checkExists().forPath(path)) {
                log.info("No node exists for path: {}. Will create now.", (Object)path);
                this.createPath(serviceNode, serializer);
            } else {
                this.curatorFramework.setData().forPath(path, serializer.serialize(serviceNode));
            }
        }
        catch (Exception e) {
            log.error("Error updating node data at path " + path, (Throwable)e);
            Exceptions.illegalState((Throwable)e);
        }
    }

    private synchronized void createPath(ServiceNode<T> serviceNode, S serializer) {
        String instancePath = PathBuilder.instancePath(this.service, serviceNode);
        try {
            if (null == this.curatorFramework.checkExists().forPath(instancePath)) {
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(instancePath, serializer.serialize(serviceNode));
                log.info("Created instance path: {}", (Object)instancePath);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            log.warn("Node already exists.. Race condition?", (Throwable)e);
        }
        catch (Exception e) {
            String message = String.format("Could not create node for %s after 60 retries (1 min). This service will not be discoverable. Retry after some time.", this.service.getServiceName());
            log.error(message, (Throwable)e);
            Exceptions.illegalState((String)message, (Throwable)e);
        }
    }
}

