/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zookeeper.servicefinder;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finder.SimpleUnshardedServiceFinder;
import io.appform.ranger.core.finder.SimpleUnshardedServiceFinderBuilder;
import io.appform.ranger.core.model.NodeDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.signals.Signal;
import io.appform.ranger.zookeeper.serde.ZkNodeDataDeserializer;
import io.appform.ranger.zookeeper.servicefinder.ZkNodeDataSource;
import io.appform.ranger.zookeeper.servicefinder.signals.ZkWatcherRegistryUpdateSignal;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkSimpleUnshardedServiceFinderBuilder<T>
extends SimpleUnshardedServiceFinderBuilder<T, ZkSimpleUnshardedServiceFinderBuilder<T>, ZkNodeDataDeserializer<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkSimpleUnshardedServiceFinderBuilder.class);
    private CuratorFramework curatorFramework;
    private String connectionString;

    public ZkSimpleUnshardedServiceFinderBuilder<T> withCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
        return this;
    }

    public ZkSimpleUnshardedServiceFinderBuilder<T> withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public SimpleUnshardedServiceFinder<T> build() {
        boolean curatorProvided;
        boolean bl = curatorProvided = this.curatorFramework != null;
        if (!curatorProvided) {
            Preconditions.checkNotNull((Object)this.connectionString);
            this.curatorFramework = CuratorFrameworkFactory.builder().namespace(this.namespace).connectString(this.connectionString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 100)).build();
            super.withStartSignalHandler(x -> this.curatorFramework.start());
            super.withStopSignalHandler(x -> this.curatorFramework.close());
        }
        return (SimpleUnshardedServiceFinder)this.buildFinder();
    }

    protected NodeDataSource<T, ZkNodeDataDeserializer<T>> dataSource(Service service) {
        return new ZkNodeDataSource(service, this.curatorFramework);
    }

    protected List<Signal<T>> implementationSpecificRefreshSignals(Service service, NodeDataSource<T, ZkNodeDataDeserializer<T>> nodeDataSource) {
        if (!this.disablePushUpdaters) {
            return Collections.singletonList(new ZkWatcherRegistryUpdateSignal(service, nodeDataSource, this.curatorFramework));
        }
        log.info("Push based signal updater not registered for service: {}", (Object)service.getServiceName());
        return Collections.emptyList();
    }
}

