/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zookeeper.common;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.AttemptTimeLimiters;
import com.github.rholder.retry.BlockStrategies;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.WaitStrategies;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.NodeDataStoreConnector;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.util.Exceptions;
import io.appform.ranger.zookeeper.common.ZkStoreType;
import io.appform.ranger.zookeeper.util.PathBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkNodeDataStoreConnector<T>
implements NodeDataStoreConnector<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkNodeDataStoreConnector.class);
    protected final Service service;
    protected final CuratorFramework curatorFramework;
    protected final ZkStoreType storeType;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final Retryer<Boolean> discoveryRetrier = RetryerBuilder.newBuilder().retryIfException(e -> IllegalStateException.class.isAssignableFrom(e.getClass())).retryIfResult(aBoolean -> false).withAttemptTimeLimiter(AttemptTimeLimiters.noTimeLimit()).withWaitStrategy(WaitStrategies.fixedWait((long)1L, (TimeUnit)TimeUnit.SECONDS)).withBlockStrategy(BlockStrategies.threadSleepStrategy()).withRetryListener(new RetryListener(){

        public <V> void onRetry(Attempt<V> attempt) {
            log.debug("Retrying with attempt: {}", attempt);
        }
    }).build();

    protected ZkNodeDataStoreConnector(Service service, CuratorFramework curatorFramework, ZkStoreType storeType) {
        this.service = service;
        this.curatorFramework = curatorFramework;
        this.storeType = storeType;
    }

    public void start() {
        if (this.storeType == ZkStoreType.SOURCE) {
            log.info("Start called on a data source will not do anything, since we don't have to create paths for services found in source. Ignoring after setting started");
            this.started.set(true);
            return;
        }
        if (this.started.get()) {
            log.info("Start called on already initialized data source for service {}. Ignoring.", (Object)this.service.getServiceName());
            return;
        }
        String path = PathBuilder.servicePath(this.service);
        try {
            this.curatorFramework.blockUntilConnected();
            log.info("Connected to zookeeper cluster for {}", (Object)this.service.getServiceName());
            this.curatorFramework.create().creatingParentContainersIfNeeded().forPath(path);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NODEEXISTS) {
                log.info("Service node {} already exists for service: {}", (Object)path, (Object)this.service.getServiceName());
            }
        }
        catch (InterruptedException e) {
            log.error("Thread interrupted");
            Thread.currentThread().interrupt();
            Exceptions.illegalState((String)("Could not start ZK data source for service: " + this.service.getServiceName() + " as thread was interrupted"));
        }
        catch (Exception e) {
            Exceptions.illegalState((String)("Could not start ZK data source for service: " + this.service.getServiceName()), (Throwable)e);
        }
        this.started.set(true);
    }

    public void ensureConnected() {
        try {
            this.discoveryRetrier.call(this::isActive);
        }
        catch (Exception e) {
            Exceptions.illegalState((String)"Could not get zk connection", (Throwable)e);
        }
    }

    public void stop() {
        if (this.stopped.get()) {
            log.info("Data source has already been stopped for: {}. Ignoring.", (Object)this.service.getServiceName());
            return;
        }
        if (!this.started.get()) {
            log.warn("Shutdown called for service: {}, but data source is not started.", (Object)this.service.getServiceName());
        }
        log.info("Shutting down data source for service: {}.  (It's a no-op.)", (Object)this.service.getServiceName());
        this.stopped.set(true);
    }

    public boolean isActive() {
        return this.curatorFramework != null && this.curatorFramework.getState() == CuratorFrameworkState.STARTED;
    }

    protected boolean isStarted() {
        return this.started.get();
    }

    protected boolean isStopped() {
        return this.stopped.get();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected Service getService() {
        return this.service;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected CuratorFramework getCuratorFramework() {
        return this.curatorFramework;
    }
}

