/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zookeeper.servicefinderhub;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.zookeeper.util.PathBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServiceDataSource
implements ServiceDataSource {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkServiceDataSource.class);
    private final String namespace;
    private final String connectionString;
    private CuratorFramework curatorFramework;
    private boolean curatorProvided;

    public ZkServiceDataSource(String namespace, String connectionString, CuratorFramework curatorFramework) {
        this.namespace = namespace;
        this.connectionString = connectionString;
        this.curatorFramework = curatorFramework;
    }

    public Collection<Service> services() {
        List children = (List)this.curatorFramework.getChildren().forPath(PathBuilder.REGISTERED_SERVICES_PATH);
        return null == children ? Collections.emptySet() : (Collection)children.stream().map(child -> Service.builder().namespace(this.namespace).serviceName(child).build()).collect(Collectors.toSet());
    }

    public void start() {
        if (null == this.curatorFramework) {
            Preconditions.checkNotNull((Object)this.connectionString);
            log.info("Building custom curator framework");
            this.curatorFramework = CuratorFrameworkFactory.builder().namespace(this.namespace).connectString(this.connectionString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 100)).build();
            this.curatorFramework.start();
            this.curatorProvided = false;
        }
        try {
            this.curatorFramework.blockUntilConnected();
        }
        catch (InterruptedException e) {
            log.error("Curator block interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        log.info("Service data source started. Curator state is: {}", (Object)this.curatorFramework.getState().name());
    }

    public void stop() {
        log.info("Service data stopped");
        if (!this.curatorProvided) {
            this.curatorFramework.close();
        }
        log.info("Service data source stopped");
    }
}

