/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zookeeper.servicefinder.signals;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.NodeDataStoreConnector;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.signals.Signal;
import io.appform.ranger.zookeeper.util.PathBuilder;
import java.util.Collections;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkWatcherRegistryUpdateSignal<T>
extends Signal<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkWatcherRegistryUpdateSignal.class);
    private final Service service;
    private final NodeDataStoreConnector<T> dataSource;
    private final CuratorFramework curatorFramework;

    public ZkWatcherRegistryUpdateSignal(Service service, NodeDataStoreConnector<T> dataSource, CuratorFramework curatorFramework) {
        super(() -> null, Collections.emptyList());
        this.service = service;
        this.dataSource = dataSource;
        this.curatorFramework = curatorFramework;
    }

    public void start() {
        this.dataSource.ensureConnected();
        log.info("Node data source is connected, Initializing watchers for service: {}", (Object)this.service.getServiceName());
        try {
            ((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher(event -> {
                if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                    this.onSignalReceived();
                }
            })).forPath(PathBuilder.servicePath(this.service));
        }
        catch (Exception e) {
            log.error("Could not setup ZK watchers for service: " + this.service.getServiceName(), (Throwable)e);
        }
        log.info("Started polling zookeeper for changes for service: {}", (Object)this.service.getServiceName());
    }

    public void stop() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZkWatcherRegistryUpdateSignal)) {
            return false;
        }
        ZkWatcherRegistryUpdateSignal other = (ZkWatcherRegistryUpdateSignal)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Service this$service = this.service;
        Service other$service = other.service;
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        NodeDataStoreConnector<T> this$dataSource = this.dataSource;
        NodeDataStoreConnector<T> other$dataSource = other.dataSource;
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        CuratorFramework this$curatorFramework = this.curatorFramework;
        CuratorFramework other$curatorFramework = other.curatorFramework;
        return !(this$curatorFramework == null ? other$curatorFramework != null : !this$curatorFramework.equals(other$curatorFramework));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZkWatcherRegistryUpdateSignal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Service $service = this.service;
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        NodeDataStoreConnector<T> $dataSource = this.dataSource;
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        CuratorFramework $curatorFramework = this.curatorFramework;
        result = result * 59 + ($curatorFramework == null ? 43 : $curatorFramework.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ZkWatcherRegistryUpdateSignal(super=" + super.toString() + ", service=" + this.service + ", dataSource=" + this.dataSource + ", curatorFramework=" + this.curatorFramework + ")";
    }
}

