/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zookeeper.serviceprovider;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.NodeDataSink;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.serviceprovider.BaseServiceProviderBuilder;
import io.appform.ranger.core.serviceprovider.ServiceProvider;
import io.appform.ranger.zookeeper.serde.ZkNodeDataSerializer;
import io.appform.ranger.zookeeper.serviceprovider.ZkNodeDataSink;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServiceProviderBuilder<T>
extends BaseServiceProviderBuilder<T, ZkServiceProviderBuilder<T>, ZkNodeDataSerializer<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkServiceProviderBuilder.class);
    private CuratorFramework curatorFramework;
    private String connectionString;

    public ZkServiceProviderBuilder<T> withCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
        return this;
    }

    public ZkServiceProviderBuilder<T> withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public ServiceProvider<T, ZkNodeDataSerializer<T>> build() {
        if (null == this.curatorFramework) {
            Preconditions.checkNotNull((Object)this.connectionString);
            log.info("Building custom curator framework");
            this.curatorFramework = CuratorFrameworkFactory.builder().namespace(this.namespace).connectString(this.connectionString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 100)).build();
            super.withStartSignalHandler(x -> this.curatorFramework.start());
            super.withStopSignalHandler(x -> this.curatorFramework.close());
        }
        return super.buildProvider();
    }

    protected NodeDataSink<T, ZkNodeDataSerializer<T>> dataSink(Service service) {
        return new ZkNodeDataSink(service, this.curatorFramework);
    }
}

