/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zookeeper.servicefinderhub;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.finderhub.ServiceFinderHubBuilder;
import io.appform.ranger.core.model.ServiceRegistry;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServiceFinderHubBuilder<T, R extends ServiceRegistry<T>>
extends ServiceFinderHubBuilder<T, R> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkServiceFinderHubBuilder.class);
    private String namespace;
    private CuratorFramework curatorFramework;
    private String connectionString;

    public ZkServiceFinderHubBuilder<T, R> withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ZkServiceFinderHubBuilder<T, R> withCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
        return this;
    }

    public ZkServiceFinderHubBuilder<T, R> withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    protected void preBuild() {
        if (null == this.curatorFramework) {
            Preconditions.checkNotNull((Object)this.connectionString);
            log.info("Building custom curator framework");
            this.curatorFramework = CuratorFrameworkFactory.builder().namespace(this.namespace).connectString(this.connectionString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 100)).build();
            super.withExtraStartSignalConsumer(x -> this.curatorFramework.start());
            super.withExtraStartSignalConsumer(x -> this.curatorFramework.close());
        }
    }

    protected void postBuild(ServiceFinderHub<T, R> serviceFinderHub) {
        log.debug("No post build steps necessary");
    }
}

