/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.server.bundle;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerHubClient;
import io.appform.ranger.client.zk.UnshardedRangerZKHubClient;
import io.appform.ranger.common.server.ShardInfo;
import io.appform.ranger.core.finder.serviceregistry.ListBasedServiceRegistry;
import io.appform.ranger.core.model.Deserializer;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.signals.Signal;
import io.appform.ranger.server.bundle.RangerServerBundle;
import io.appform.ranger.server.bundle.config.RangerConfiguration;
import io.appform.ranger.server.bundle.healthcheck.RangerHealthCheck;
import io.appform.ranger.server.bundle.lifecycle.CuratorLifecycle;
import io.appform.ranger.zookeeper.serde.ZkNodeDataDeserializer;
import io.dropwizard.Configuration;
import java.io.IOException;
import java.util.List;
import javax.inject.Singleton;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class ZKServerBundle<U extends Configuration>
extends RangerServerBundle<ShardInfo, ListBasedServiceRegistry<ShardInfo>, U> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZKServerBundle.class);
    private CuratorFramework curatorFramework;

    protected abstract RangerConfiguration getRangerConfiguration(U var1);

    protected void preBundle(U configuration) {
        RangerConfiguration rangerConfiguration = this.getRangerConfiguration(configuration);
        this.curatorFramework = CuratorFrameworkFactory.builder().connectString(rangerConfiguration.getZookeeper()).namespace(rangerConfiguration.getNamespace()).retryPolicy((RetryPolicy)new RetryForever(5000)).build();
    }

    protected List<RangerHubClient<ShardInfo, ListBasedServiceRegistry<ShardInfo>>> withHubs(U configuration) {
        RangerConfiguration rangerConfiguration = this.getRangerConfiguration(configuration);
        return ImmutableList.of((Object)((UnshardedRangerZKHubClient.UnshardedRangerZKHubClientBuilder)((UnshardedRangerZKHubClient.UnshardedRangerZKHubClientBuilder)((UnshardedRangerZKHubClient.UnshardedRangerZKHubClientBuilder)((UnshardedRangerZKHubClient.UnshardedRangerZKHubClientBuilder)((UnshardedRangerZKHubClient.UnshardedRangerZKHubClientBuilder)((UnshardedRangerZKHubClient.UnshardedRangerZKHubClientBuilder)((UnshardedRangerZKHubClient.UnshardedRangerZKHubClientBuilder)UnshardedRangerZKHubClient.builder().namespace(rangerConfiguration.getNamespace())).connectionString(rangerConfiguration.getZookeeper())).curatorFramework(this.curatorFramework)).disablePushUpdaters(rangerConfiguration.isDisablePushUpdaters())).mapper(this.getMapper())).nodeRefreshTimeMs(rangerConfiguration.getNodeRefreshTimeMs())).deserializer((Deserializer)((ZkNodeDataDeserializer)data -> {
            try {
                return (ServiceNode)this.getMapper().readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
            }
            catch (IOException e) {
                log.warn("Error parsing node data with value {}", (Object)new String(data));
                return null;
            }
        }))).build());
    }

    protected List<Signal<ShardInfo>> withLifecycleSignals(U configuration) {
        return ImmutableList.of((Object)((Object)new CuratorLifecycle(this.curatorFramework)));
    }

    protected List<HealthCheck> withHealthChecks(U configuration) {
        return ImmutableList.of((Object)((Object)new RangerHealthCheck(this.curatorFramework)));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZKServerBundle() {
    }
}

