/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.zk.server.bundle.lifecycle;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.common.server.ShardInfo;
import io.appform.ranger.core.signals.Signal;
import java.util.Collections;
import javax.inject.Singleton;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CuratorLifecycle
extends Signal<ShardInfo> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CuratorLifecycle.class);
    private final CuratorFramework curatorFramework;

    public CuratorLifecycle(CuratorFramework curatorFramework) {
        super(() -> null, Collections.emptyList());
        this.curatorFramework = curatorFramework;
    }

    public void start() {
        log.info("Starting the curator");
        this.curatorFramework.start();
        try {
            this.curatorFramework.blockUntilConnected();
        }
        catch (InterruptedException e) {
            log.error("Curator block interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        log.info("Started the curator");
    }

    public void stop() {
        this.curatorFramework.close();
    }
}

