/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client.zk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.AbstractRangerClient;
import io.appform.ranger.core.finder.SimpleShardedServiceFinder;
import io.appform.ranger.core.finder.serviceregistry.MapBasedServiceRegistry;
import io.appform.ranger.core.finder.shardselector.MatchingShardSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.zookeeper.ServiceFinderBuilders;
import io.appform.ranger.zookeeper.serde.ZkNodeDataDeserializer;
import io.appform.ranger.zookeeper.servicefinder.ZkSimpleShardedServiceFinderBuilder;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRangerZKClient<T>
extends AbstractRangerClient<T, MapBasedServiceRegistry<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleRangerZKClient.class);
    private final String serviceName;
    private final String namespace;
    private final ObjectMapper mapper;
    private final boolean disableWatchers;
    private final String connectionString;
    private final ZkNodeDataDeserializer<T> deserializer;
    private CuratorFramework curatorFramework;
    private int nodeRefreshIntervalMs;
    private SimpleShardedServiceFinder<T> serviceFinder;
    private ShardSelector<T, MapBasedServiceRegistry<T>> shardSelector;

    public void start() {
        log.info("Starting the service finder");
        Preconditions.checkNotNull((Object)this.mapper, (Object)"Mapper can't be null");
        Preconditions.checkNotNull((Object)this.namespace, (Object)"namespace can't be null");
        Preconditions.checkNotNull(this.deserializer, (Object)"deserializer can't be null");
        int effectiveRefreshTime = this.nodeRefreshIntervalMs;
        if (effectiveRefreshTime < 5000) {
            effectiveRefreshTime = 5000;
            log.warn("Node info update interval too low: {} ms. Has been upgraded to {} ms ", (Object)this.nodeRefreshIntervalMs, (Object)5000);
        }
        if (null == this.curatorFramework) {
            Preconditions.checkNotNull((Object)this.connectionString, (Object)"Connection string can't be null");
            this.curatorFramework = CuratorFrameworkFactory.builder().connectString(this.connectionString).namespace(this.namespace).retryPolicy((RetryPolicy)new RetryForever(5000)).build();
        }
        this.serviceFinder = ((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)ServiceFinderBuilders.shardedFinderBuilder().withCuratorFramework(this.curatorFramework).withNamespace(this.namespace)).withServiceName(this.serviceName)).withDeserializer(this.deserializer)).withNodeRefreshIntervalMs(effectiveRefreshTime)).withDisableWatchers(this.disableWatchers)).withShardSelector(this.shardSelector)).build();
        this.serviceFinder.start();
    }

    public void stop() {
        log.info("Stopping the service finder");
        if (null != this.serviceFinder) {
            this.serviceFinder.stop();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static <T> ShardSelector<T, MapBasedServiceRegistry<T>> $default$shardSelector() {
        return new MatchingShardSelector();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected SimpleRangerZKClient(SimpleRangerZKClientBuilder<T, ?, ?> b) {
        super(b);
        this.serviceName = ((SimpleRangerZKClientBuilder)b).serviceName;
        this.namespace = ((SimpleRangerZKClientBuilder)b).namespace;
        this.mapper = ((SimpleRangerZKClientBuilder)b).mapper;
        this.disableWatchers = ((SimpleRangerZKClientBuilder)b).disableWatchers;
        this.connectionString = ((SimpleRangerZKClientBuilder)b).connectionString;
        this.deserializer = ((SimpleRangerZKClientBuilder)b).deserializer;
        this.curatorFramework = ((SimpleRangerZKClientBuilder)b).curatorFramework;
        this.nodeRefreshIntervalMs = ((SimpleRangerZKClientBuilder)b).nodeRefreshIntervalMs;
        this.serviceFinder = ((SimpleRangerZKClientBuilder)b).serviceFinder;
        this.shardSelector = ((SimpleRangerZKClientBuilder)b).shardSelector$set ? ((SimpleRangerZKClientBuilder)b).shardSelector$value : SimpleRangerZKClient.$default$shardSelector();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> SimpleRangerZKClientBuilder<T, ?, ?> builder() {
        return new SimpleRangerZKClientBuilderImpl();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDisableWatchers() {
        return this.disableWatchers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getConnectionString() {
        return this.connectionString;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZkNodeDataDeserializer<T> getDeserializer() {
        return this.deserializer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CuratorFramework getCuratorFramework() {
        return this.curatorFramework;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getNodeRefreshIntervalMs() {
        return this.nodeRefreshIntervalMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SimpleShardedServiceFinder<T> getServiceFinder() {
        return this.serviceFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ShardSelector<T, MapBasedServiceRegistry<T>> getShardSelector() {
        return this.shardSelector;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final class SimpleRangerZKClientBuilderImpl<T>
    extends SimpleRangerZKClientBuilder<T, SimpleRangerZKClient<T>, SimpleRangerZKClientBuilderImpl<T>> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SimpleRangerZKClientBuilderImpl() {
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected SimpleRangerZKClientBuilderImpl<T> self() {
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerZKClient<T> build() {
            return new SimpleRangerZKClient(this);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static abstract class SimpleRangerZKClientBuilder<T, C extends SimpleRangerZKClient<T>, B extends SimpleRangerZKClientBuilder<T, C, B>>
    extends AbstractRangerClient.AbstractRangerClientBuilder<T, MapBasedServiceRegistry<T>, C, B> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String serviceName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean disableWatchers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String connectionString;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZkNodeDataDeserializer<T> deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CuratorFramework curatorFramework;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshIntervalMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SimpleShardedServiceFinder<T> serviceFinder;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean shardSelector$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ShardSelector<T, MapBasedServiceRegistry<T>> shardSelector$value;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected abstract B self();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public abstract C build();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B serviceName(String serviceName) {
            this.serviceName = serviceName;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B connectionString(String connectionString) {
            this.connectionString = connectionString;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B deserializer(ZkNodeDataDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B curatorFramework(CuratorFramework curatorFramework) {
            this.curatorFramework = curatorFramework;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B nodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
            this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B serviceFinder(SimpleShardedServiceFinder<T> serviceFinder) {
            this.serviceFinder = serviceFinder;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B shardSelector(ShardSelector<T, MapBasedServiceRegistry<T>> shardSelector) {
            this.shardSelector$value = shardSelector;
            this.shardSelector$set = true;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SimpleRangerZKClient.SimpleRangerZKClientBuilder(super=" + super.toString() + ", serviceName=" + this.serviceName + ", namespace=" + this.namespace + ", mapper=" + this.mapper + ", disableWatchers=" + this.disableWatchers + ", connectionString=" + this.connectionString + ", deserializer=" + this.deserializer + ", curatorFramework=" + this.curatorFramework + ", nodeRefreshIntervalMs=" + this.nodeRefreshIntervalMs + ", serviceFinder=" + this.serviceFinder + ", shardSelector$value=" + this.shardSelector$value + ")";
        }
    }
}

