/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client.zk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.AbstractRangerClient;
import io.appform.ranger.core.finder.SimpleShardedServiceFinder;
import io.appform.ranger.core.finder.serviceregistry.MapBasedServiceRegistry;
import io.appform.ranger.core.finder.shardselector.MatchingShardSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.zookeeper.ServiceFinderBuilders;
import io.appform.ranger.zookeeper.serde.ZkNodeDataDeserializer;
import io.appform.ranger.zookeeper.servicefinder.ZkSimpleShardedServiceFinderBuilder;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRangerZKClient<T>
extends AbstractRangerClient<T, MapBasedServiceRegistry<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleRangerZKClient.class);
    private final SimpleShardedServiceFinder<T> serviceFinder;
    private final ZkNodeDataDeserializer<T> deserializer;

    public SimpleRangerZKClient(String namespace, String serviceName, ObjectMapper mapper, int nodeRefreshIntervalMs, boolean disableWatchers, String connectionString, Predicate<T> initialCriteria, ZkNodeDataDeserializer<T> deserializer, boolean alwaysUseInitialCriteria) {
        this(namespace, serviceName, mapper, nodeRefreshIntervalMs, disableWatchers, CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)new RetryForever(5000)), initialCriteria, deserializer, alwaysUseInitialCriteria);
    }

    public SimpleRangerZKClient(String namespace, String serviceName, ObjectMapper mapper, int nodeRefreshIntervalMs, boolean disableWatchers, CuratorFramework curatorFramework, Predicate<T> initialCriteria, ZkNodeDataDeserializer<T> deserializer, boolean alwaysUseInitialCriteria) {
        super(initialCriteria, alwaysUseInitialCriteria);
        Preconditions.checkNotNull((Object)mapper, (Object)"Mapper can't be null");
        Preconditions.checkNotNull((Object)namespace, (Object)"namespace can't be null");
        Preconditions.checkNotNull(deserializer, (Object)"deserializer can't be null");
        int effectiveRefreshTime = nodeRefreshIntervalMs;
        if (effectiveRefreshTime < 5000) {
            effectiveRefreshTime = 5000;
            log.warn("Node info update interval too low: {} ms. Has been upgraded to {} ms ", (Object)nodeRefreshIntervalMs, (Object)5000);
        }
        this.deserializer = deserializer;
        this.serviceFinder = ((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)((ZkSimpleShardedServiceFinderBuilder)ServiceFinderBuilders.shardedFinderBuilder().withCuratorFramework(curatorFramework).withNamespace(namespace)).withServiceName(serviceName)).withDeserializer(deserializer)).withNodeRefreshIntervalMs(effectiveRefreshTime)).withDisableWatchers(disableWatchers)).withShardSelector((ShardSelector)new MatchingShardSelector())).build();
    }

    public void start() {
        log.info("Starting the service finder");
        this.serviceFinder.start();
    }

    public void stop() {
        log.info("Stopping the service finder");
        this.serviceFinder.stop();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> FromConnectionStringBuilder<T> fromConnectionString() {
        return new FromConnectionStringBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> FromCuratorBuilder<T> fromCurator() {
        return new FromCuratorBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SimpleShardedServiceFinder<T> getServiceFinder() {
        return this.serviceFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZkNodeDataDeserializer<T> getDeserializer() {
        return this.deserializer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class FromCuratorBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String serviceName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshIntervalMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean disableWatchers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CuratorFramework curatorFramework;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Predicate<T> initialCriteria;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZkNodeDataDeserializer<T> deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean alwaysUseInitialCriteria;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        FromCuratorBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> nodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
            this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> curatorFramework(CuratorFramework curatorFramework) {
            this.curatorFramework = curatorFramework;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> initialCriteria(Predicate<T> initialCriteria) {
            this.initialCriteria = initialCriteria;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> deserializer(ZkNodeDataDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromCuratorBuilder<T> alwaysUseInitialCriteria(boolean alwaysUseInitialCriteria) {
            this.alwaysUseInitialCriteria = alwaysUseInitialCriteria;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerZKClient<T> build() {
            return new SimpleRangerZKClient<T>(this.namespace, this.serviceName, this.mapper, this.nodeRefreshIntervalMs, this.disableWatchers, this.curatorFramework, this.initialCriteria, this.deserializer, this.alwaysUseInitialCriteria);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SimpleRangerZKClient.FromCuratorBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", mapper=" + this.mapper + ", nodeRefreshIntervalMs=" + this.nodeRefreshIntervalMs + ", disableWatchers=" + this.disableWatchers + ", curatorFramework=" + this.curatorFramework + ", initialCriteria=" + this.initialCriteria + ", deserializer=" + this.deserializer + ", alwaysUseInitialCriteria=" + this.alwaysUseInitialCriteria + ")";
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class FromConnectionStringBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String serviceName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshIntervalMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean disableWatchers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String connectionString;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Predicate<T> initialCriteria;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZkNodeDataDeserializer<T> deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean alwaysUseInitialCriteria;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        FromConnectionStringBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> nodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
            this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> initialCriteria(Predicate<T> initialCriteria) {
            this.initialCriteria = initialCriteria;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> deserializer(ZkNodeDataDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FromConnectionStringBuilder<T> alwaysUseInitialCriteria(boolean alwaysUseInitialCriteria) {
            this.alwaysUseInitialCriteria = alwaysUseInitialCriteria;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerZKClient<T> build() {
            return new SimpleRangerZKClient<T>(this.namespace, this.serviceName, this.mapper, this.nodeRefreshIntervalMs, this.disableWatchers, this.connectionString, this.initialCriteria, this.deserializer, this.alwaysUseInitialCriteria);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SimpleRangerZKClient.FromConnectionStringBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", mapper=" + this.mapper + ", nodeRefreshIntervalMs=" + this.nodeRefreshIntervalMs + ", disableWatchers=" + this.disableWatchers + ", connectionString=" + this.connectionString + ", initialCriteria=" + this.initialCriteria + ", deserializer=" + this.deserializer + ", alwaysUseInitialCriteria=" + this.alwaysUseInitialCriteria + ")";
        }
    }
}

