/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client.zk;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.AbstractRangerHubClient;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.finderhub.StaticDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.zookeeper.serde.ZkNodeDataDeserializer;
import io.appform.ranger.zookeeper.servicefinderhub.ZkServiceDataSource;
import io.appform.ranger.zookeeper.servicefinderhub.ZkServiceFinderHubBuilder;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRangerZKHubClient<T, R extends ServiceRegistry<T>, D extends ZkNodeDataDeserializer<T>>
extends AbstractRangerHubClient<T, R, D> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRangerZKHubClient.class);
    private final boolean disablePushUpdaters;
    private final String connectionString;
    private final CuratorFramework curatorFramework;
    private final Set<Service> services;

    protected AbstractRangerZKHubClient(String namespace, ObjectMapper mapper, int nodeRefreshIntervalMs, boolean disablePushUpdaters, String connectionString, CuratorFramework curatorFramework, Predicate<T> criteria, D deserializer, Set<Service> services, boolean alwaysUseInitialCriteria) {
        super(namespace, mapper, nodeRefreshIntervalMs, criteria, deserializer, alwaysUseInitialCriteria);
        this.disablePushUpdaters = disablePushUpdaters;
        this.connectionString = connectionString;
        this.services = null != services ? services : Collections.emptySet();
        this.curatorFramework = curatorFramework;
    }

    protected ServiceFinderHub<T, R> buildHub() {
        return new ZkServiceFinderHubBuilder().withCuratorFramework(this.curatorFramework).withConnectionString(this.connectionString).withNamespace(this.getNamespace()).withRefreshFrequencyMs((long)this.getNodeRefreshTimeMs()).withServiceDataSource(this.buildServiceDataSource()).withServiceFinderFactory(this.buildFinderFactory()).build();
    }

    protected ServiceDataSource buildServiceDataSource() {
        return !this.services.isEmpty() ? new StaticDataSource(this.services) : new ZkServiceDataSource(this.getNamespace(), this.connectionString, this.curatorFramework);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDisablePushUpdaters() {
        return this.disablePushUpdaters;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getConnectionString() {
        return this.connectionString;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CuratorFramework getCuratorFramework() {
        return this.curatorFramework;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<Service> getServices() {
        return this.services;
    }
}

