/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.server.bundle.resources;

import com.codahale.metrics.annotation.Timed;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerHubClient;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.http.response.model.GenericResponse;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/ranger")
public class RangerResource<T, R extends ServiceRegistry<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RangerResource.class);
    private final List<RangerHubClient<T, R>> rangerHubs;

    @Inject
    public RangerResource(List<RangerHubClient<T, R>> rangerHubs) {
        this.rangerHubs = rangerHubs;
    }

    @GET
    @Path(value="/services/v1")
    @Timed
    public GenericResponse<Set<Service>> getServices() {
        return GenericResponse.builder().data(this.rangerHubs.stream().map(RangerHubClient::getRegisteredServices).flatMap(Collection::stream).collect(Collectors.toSet())).build();
    }

    @GET
    @Path(value="/nodes/v1/{namespace}/{serviceName}")
    @Timed
    public GenericResponse<List<ServiceNode<T>>> getNodes(@NotNull @NotEmpty @PathParam(value="namespace") String namespace, @NotNull @NotEmpty @PathParam(value="serviceName") String serviceName) {
        Service service = Service.builder().namespace(namespace).serviceName(serviceName).build();
        return GenericResponse.builder().data(this.rangerHubs.stream().map(hub -> hub.getAllNodes(service)).flatMap(Collection::stream).collect(Collectors.toList())).build();
    }
}

