/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.server.bundle;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerHubClient;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.signals.Signal;
import io.appform.ranger.server.bundle.resources.RangerResource;
import io.appform.ranger.server.bundle.rotation.BirTask;
import io.appform.ranger.server.bundle.rotation.OorTask;
import io.appform.ranger.server.bundle.rotation.RotationCheck;
import io.appform.ranger.server.bundle.rotation.RotationStatus;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerServerBundle<T, R extends ServiceRegistry<T>, U extends Configuration>
implements ConfiguredBundle<U> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RangerServerBundle.class);
    private List<RangerHubClient<T, R>> hubs;
    private ObjectMapper mapper;

    protected void preBundle(U configuration) {
    }

    protected boolean withInitialRotationStatus(U configuration) {
        return true;
    }

    protected List<Signal<T>> withLifecycleSignals(U configuration) {
        return ImmutableList.of();
    }

    protected abstract List<RangerHubClient<T, R>> withHubs(U var1);

    protected abstract List<HealthCheck> withHealthChecks(U var1);

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(U configuration, Environment environment) {
        this.preBundle(configuration);
        this.mapper = environment.getObjectMapper();
        this.hubs = this.withHubs(configuration);
        RotationStatus rotationStatus = new RotationStatus(this.withInitialRotationStatus(configuration));
        final List<Signal<T>> lifecycleSignals = this.withLifecycleSignals(configuration);
        List<HealthCheck> healthChecks = this.withHealthChecks(configuration);
        environment.admin().addTask((Task)new OorTask(rotationStatus));
        environment.admin().addTask((Task)new BirTask(rotationStatus));
        environment.lifecycle().manage(new Managed(){

            public void start() {
                log.info("Starting the server manager");
                lifecycleSignals.forEach(Signal::start);
                RangerServerBundle.this.hubs.forEach(RangerHubClient::start);
                log.info("Started the server manager");
            }

            public void stop() {
                log.info("Stopping the server manager");
                RangerServerBundle.this.hubs.forEach(RangerHubClient::stop);
                lifecycleSignals.forEach(Signal::stop);
                log.info("Stopped the server manager");
            }
        });
        environment.healthChecks().register("rotation-check", (HealthCheck)new RotationCheck(rotationStatus));
        healthChecks.forEach(healthCheck -> environment.healthChecks().register(healthCheck.getClass().getName(), healthCheck));
        environment.jersey().register(new RangerResource<T, R>(this.hubs));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<RangerHubClient<T, R>> getHubs() {
        return this.hubs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

