/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.http.servicefinder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.NodeDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.util.FinderUtils;
import io.appform.ranger.http.common.HttpNodeDataStoreConnector;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.model.ServiceNodesResponse;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNodeDataSource<T, D extends HTTPResponseDataDeserializer<T>>
extends HttpNodeDataStoreConnector<T>
implements NodeDataSource<T, D> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpNodeDataSource.class);
    private final Service service;

    public HttpNodeDataSource(Service service, HttpClientConfig config, ObjectMapper mapper) {
        super(config, mapper);
        this.service = service;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ServiceNode<T>> refresh(D deserializer) {
        Preconditions.checkNotNull((Object)this.config, (Object)"client config has not been set for node data");
        Preconditions.checkNotNull((Object)this.mapper, (Object)"mapper has not been set for node data");
        String url = String.format("/ranger/nodes/v1/%s/%s", this.service.getNamespace(), this.service.getServiceName());
        log.debug("Refreshing the node list from url {}", (Object)url);
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(this.config.isSecure() ? "https" : "http").host(this.config.getHost()).port(this.config.getPort() == 0 ? this.defaultPort() : this.config.getPort()).encodedPath(url).build();
        Request request = new Request.Builder().url(httpUrl).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                try (ResponseBody body = response.body();){
                    if (null == body) {
                        log.warn("HTTP call to {} returned empty body", (Object)httpUrl);
                        return Collections.emptyList();
                    }
                    byte[] bytes = body.bytes();
                    ServiceNodesResponse serviceNodesResponse = deserializer.deserialize(bytes);
                    if (serviceNodesResponse.valid()) {
                        List list = FinderUtils.filterValidNodes((Service)this.service, serviceNodesResponse.getData(), (long)this.healthcheckZombieCheckThresholdTime(this.service));
                        return list;
                    }
                    log.warn("Http call to {} returned a failure response with response {}", (Object)httpUrl, serviceNodesResponse);
                    return Collections.emptyList();
                }
            }
            log.warn("HTTP call to {} returned: {}", (Object)httpUrl, (Object)response.code());
            return Collections.emptyList();
        }
        catch (IOException e) {
            log.error("Error getting service data from the http endPoint: ", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isActive() {
        return true;
    }
}

