/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.http.serviceprovider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.NodeDataSink;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.util.Exceptions;
import io.appform.ranger.http.common.HttpNodeDataStoreConnector;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.model.ServiceRegistrationResponse;
import io.appform.ranger.http.serde.HttpRequestDataSerializer;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNodeDataSink<T, S extends HttpRequestDataSerializer<T>>
extends HttpNodeDataStoreConnector<T>
implements NodeDataSink<T, S> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpNodeDataSink.class);
    private final Service service;

    public HttpNodeDataSink(Service service, HttpClientConfig config, ObjectMapper mapper) {
        super(config, mapper);
        this.service = service;
    }

    public void updateState(S serializer, ServiceNode<T> serviceNode) {
        Preconditions.checkNotNull((Object)this.config, (Object)"client config has not been set for node data");
        Preconditions.checkNotNull((Object)this.mapper, (Object)"mapper has not been set for node data");
        String url = String.format("/ranger/nodes/v1/add/%s/%s", this.service.getNamespace(), this.service.getServiceName());
        log.debug("Updating state at the url {}", (Object)url);
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(this.config.isSecure() ? "https" : "http").host(this.config.getHost()).port(this.config.getPort() == 0 ? this.defaultPort() : this.config.getPort()).encodedPath(url).build();
        RequestBody requestBody = RequestBody.create((byte[])serializer.serialize(serviceNode));
        ServiceRegistrationResponse serviceRegistrationResponse = this.registerService(httpUrl, requestBody).orElse(null);
        if (null == serviceRegistrationResponse || !serviceRegistrationResponse.valid()) {
            log.warn("Http call to {} returned a failure response {}", (Object)httpUrl, (Object)serviceRegistrationResponse);
            Exceptions.illegalState((String)("Error updating state on the server for node data: " + httpUrl));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<ServiceRegistrationResponse> registerService(HttpUrl httpUrl, RequestBody requestBody) {
        Request request = new Request.Builder().url(httpUrl).post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                try (ResponseBody body = response.body();){
                    if (null == body) {
                        log.warn("HTTP call to {} returned empty body", (Object)httpUrl);
                        return Optional.empty();
                    }
                    byte[] bytes = body.bytes();
                    Optional<Object> optional = Optional.of(this.mapper.readValue(bytes, ServiceRegistrationResponse.class));
                    return optional;
                }
            }
            log.warn("HTTP call to {} has returned: {}", (Object)httpUrl, (Object)response.code());
            return Optional.empty();
        }
        catch (IOException e) {
            log.error("Error updating state on the server with httpUrl {} with exception {} ", (Object)httpUrl, (Object)e);
        }
        return Optional.empty();
    }
}

