/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.http.servicefinderhub;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.http.common.HttpNodeDataStoreConnector;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.model.ServiceDataSourceResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceDataSource<T>
extends HttpNodeDataStoreConnector<T>
implements ServiceDataSource {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpServiceDataSource.class);

    public HttpServiceDataSource(HttpClientConfig config, ObjectMapper mapper) {
        super(config, mapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Service> services() {
        HttpUrl httpUrl;
        block20: {
            Preconditions.checkNotNull((Object)this.config, (Object)"client config has not been set for node data");
            Preconditions.checkNotNull((Object)this.mapper, (Object)"mapper has not been set for node data");
            httpUrl = new HttpUrl.Builder().scheme(this.config.isSecure() ? "https" : "http").host(this.config.getHost()).port(this.config.getPort() == 0 ? this.defaultPort() : this.config.getPort()).encodedPath("/ranger/services/v1").build();
            Request request = new Request.Builder().url(httpUrl).get().build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    try (ResponseBody body = response.body();){
                        if (null == body) {
                            log.warn("HTTP call to {} returned empty body", (Object)httpUrl);
                            break block20;
                        } else {
                            byte[] bytes = body.bytes();
                            ServiceDataSourceResponse serviceDataSourceResponse = (ServiceDataSourceResponse)this.mapper.readValue(bytes, ServiceDataSourceResponse.class);
                            if (serviceDataSourceResponse.valid()) {
                                Set<Service> set = serviceDataSourceResponse.getData();
                                return set;
                            }
                            log.warn("Http call to {} returned a failure response with data {}", (Object)httpUrl, (Object)serviceDataSourceResponse);
                        }
                        break block20;
                    }
                }
                log.warn("HTTP call to {} returned code: {}", (Object)httpUrl, (Object)response.code());
            }
            catch (IOException e) {
                log.info("Error parsing the response from server for : {} with exception {}", (Object)httpUrl, (Object)e);
            }
        }
        log.error("No data returned from server: " + httpUrl);
        return Collections.emptySet();
    }
}

