/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.http.servicefinderhub;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finder.ServiceFinder;
import io.appform.ranger.core.finder.SimpleUnshardedServiceFinder;
import io.appform.ranger.core.finder.serviceregistry.ListBasedServiceRegistry;
import io.appform.ranger.core.finderhub.ServiceFinderFactory;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import io.appform.ranger.http.servicefinder.HttpUnshardedServiceFinderBuilider;
import lombok.Generated;

public class HttpUnshardedServiceFinderFactory<T>
implements ServiceFinderFactory<T, ListBasedServiceRegistry<T>> {
    private final HttpClientConfig clientConfig;
    private final ObjectMapper mapper;
    private final HTTPResponseDataDeserializer<T> deserializer;
    private final ShardSelector<T, ListBasedServiceRegistry<T>> shardSelector;
    private final ServiceNodeSelector<T> nodeSelector;
    private final int nodeRefreshIntervalMs;

    public HttpUnshardedServiceFinderFactory(HttpClientConfig httpClientConfig, ObjectMapper mapper, HTTPResponseDataDeserializer<T> deserializer, ShardSelector<T, ListBasedServiceRegistry<T>> shardSelector, ServiceNodeSelector<T> nodeSelector, int nodeRefreshIntervalMs) {
        this.clientConfig = httpClientConfig;
        this.mapper = mapper;
        this.deserializer = deserializer;
        this.shardSelector = shardSelector;
        this.nodeSelector = nodeSelector;
        this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
    }

    public ServiceFinder<T, ListBasedServiceRegistry<T>> buildFinder(Service service) {
        SimpleUnshardedServiceFinder serviceFinder = ((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)new HttpUnshardedServiceFinderBuilider().withClientConfig(this.clientConfig).withObjectMapper(this.mapper).withDeserializer(this.deserializer)).withNamespace(service.getNamespace())).withServiceName(service.getServiceName())).withNodeRefreshIntervalMs(this.nodeRefreshIntervalMs)).withShardSelector(this.shardSelector)).withNodeSelector(this.nodeSelector)).build();
        serviceFinder.start();
        return serviceFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> HttpUnshardedServiceFinderFactoryBuilder<T> builder() {
        return new HttpUnshardedServiceFinderFactoryBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class HttpUnshardedServiceFinderFactoryBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HttpClientConfig httpClientConfig;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HTTPResponseDataDeserializer<T> deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ShardSelector<T, ListBasedServiceRegistry<T>> shardSelector;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ServiceNodeSelector<T> nodeSelector;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshIntervalMs;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        HttpUnshardedServiceFinderFactoryBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpUnshardedServiceFinderFactoryBuilder<T> httpClientConfig(HttpClientConfig httpClientConfig) {
            this.httpClientConfig = httpClientConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpUnshardedServiceFinderFactoryBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpUnshardedServiceFinderFactoryBuilder<T> deserializer(HTTPResponseDataDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpUnshardedServiceFinderFactoryBuilder<T> shardSelector(ShardSelector<T, ListBasedServiceRegistry<T>> shardSelector) {
            this.shardSelector = shardSelector;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpUnshardedServiceFinderFactoryBuilder<T> nodeSelector(ServiceNodeSelector<T> nodeSelector) {
            this.nodeSelector = nodeSelector;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpUnshardedServiceFinderFactoryBuilder<T> nodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
            this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpUnshardedServiceFinderFactory<T> build() {
            return new HttpUnshardedServiceFinderFactory<T>(this.httpClientConfig, this.mapper, this.deserializer, this.shardSelector, this.nodeSelector, this.nodeRefreshIntervalMs);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "HttpUnshardedServiceFinderFactory.HttpUnshardedServiceFinderFactoryBuilder(httpClientConfig=" + this.httpClientConfig + ", mapper=" + this.mapper + ", deserializer=" + this.deserializer + ", shardSelector=" + this.shardSelector + ", nodeSelector=" + this.nodeSelector + ", nodeRefreshIntervalMs=" + this.nodeRefreshIntervalMs + ")";
        }
    }
}

