/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.http.servicefinder;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.appform.ranger.core.finder.SimpleShardedServiceFinder;
import io.appform.ranger.core.finder.SimpleShardedServiceFinderBuilder;
import io.appform.ranger.core.model.NodeDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import io.appform.ranger.http.servicefinder.HttpNodeDataSource;

public class HttpShardedServiceFinderBuilder<T>
extends SimpleShardedServiceFinderBuilder<T, HttpShardedServiceFinderBuilder<T>, HTTPResponseDataDeserializer<T>> {
    private HttpClientConfig clientConfig;
    private ObjectMapper mapper;

    public HttpShardedServiceFinderBuilder<T> withClientConfig(HttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    public HttpShardedServiceFinderBuilder<T> withObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public SimpleShardedServiceFinder<T> build() {
        return (SimpleShardedServiceFinder)this.buildFinder();
    }

    protected NodeDataSource<T, HTTPResponseDataDeserializer<T>> dataSource(Service service) {
        return new HttpNodeDataSource(service, this.clientConfig, this.mapper);
    }
}

