/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.http.servicefinderhub;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finder.ServiceFinder;
import io.appform.ranger.core.finder.SimpleShardedServiceFinder;
import io.appform.ranger.core.finder.serviceregistry.MapBasedServiceRegistry;
import io.appform.ranger.core.finderhub.ServiceFinderFactory;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import io.appform.ranger.http.servicefinder.HttpShardedServiceFinderBuilder;
import lombok.Generated;

public class HttpShardedServiceFinderFactory<T>
implements ServiceFinderFactory<T, MapBasedServiceRegistry<T>> {
    private final HttpClientConfig clientConfig;
    private final ObjectMapper mapper;
    private final HTTPResponseDataDeserializer<T> deserializer;
    private final ShardSelector<T, MapBasedServiceRegistry<T>> shardSelector;
    private final ServiceNodeSelector<T> nodeSelector;
    private final int nodeRefreshIntervalMs;

    public HttpShardedServiceFinderFactory(HttpClientConfig httpClientConfig, ObjectMapper mapper, HTTPResponseDataDeserializer<T> deserializer, ShardSelector<T, MapBasedServiceRegistry<T>> shardSelector, ServiceNodeSelector<T> nodeSelector, int nodeRefreshIntervalMs) {
        this.clientConfig = httpClientConfig;
        this.mapper = mapper;
        this.deserializer = deserializer;
        this.shardSelector = shardSelector;
        this.nodeSelector = nodeSelector;
        this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
    }

    public ServiceFinder<T, MapBasedServiceRegistry<T>> buildFinder(Service service) {
        SimpleShardedServiceFinder serviceFinder = ((HttpShardedServiceFinderBuilder)((HttpShardedServiceFinderBuilder)((HttpShardedServiceFinderBuilder)((HttpShardedServiceFinderBuilder)((HttpShardedServiceFinderBuilder)((HttpShardedServiceFinderBuilder)new HttpShardedServiceFinderBuilder().withClientConfig(this.clientConfig).withObjectMapper(this.mapper).withDeserializer(this.deserializer)).withNamespace(service.getNamespace())).withServiceName(service.getServiceName())).withNodeRefreshIntervalMs(this.nodeRefreshIntervalMs)).withShardSelector(this.shardSelector)).withNodeSelector(this.nodeSelector)).build();
        serviceFinder.start();
        return serviceFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> HttpShardedServiceFinderFactoryBuilder<T> builder() {
        return new HttpShardedServiceFinderFactoryBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class HttpShardedServiceFinderFactoryBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HttpClientConfig httpClientConfig;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HTTPResponseDataDeserializer<T> deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ShardSelector<T, MapBasedServiceRegistry<T>> shardSelector;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ServiceNodeSelector<T> nodeSelector;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshIntervalMs;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        HttpShardedServiceFinderFactoryBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpShardedServiceFinderFactoryBuilder<T> httpClientConfig(HttpClientConfig httpClientConfig) {
            this.httpClientConfig = httpClientConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpShardedServiceFinderFactoryBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpShardedServiceFinderFactoryBuilder<T> deserializer(HTTPResponseDataDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpShardedServiceFinderFactoryBuilder<T> shardSelector(ShardSelector<T, MapBasedServiceRegistry<T>> shardSelector) {
            this.shardSelector = shardSelector;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpShardedServiceFinderFactoryBuilder<T> nodeSelector(ServiceNodeSelector<T> nodeSelector) {
            this.nodeSelector = nodeSelector;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpShardedServiceFinderFactoryBuilder<T> nodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
            this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HttpShardedServiceFinderFactory<T> build() {
            return new HttpShardedServiceFinderFactory<T>(this.httpClientConfig, this.mapper, this.deserializer, this.shardSelector, this.nodeSelector, this.nodeRefreshIntervalMs);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "HttpShardedServiceFinderFactory.HttpShardedServiceFinderFactoryBuilder(httpClientConfig=" + this.httpClientConfig + ", mapper=" + this.mapper + ", deserializer=" + this.deserializer + ", shardSelector=" + this.shardSelector + ", nodeSelector=" + this.nodeSelector + ", nodeRefreshIntervalMs=" + this.nodeRefreshIntervalMs + ")";
        }
    }
}

