/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.http.server.bundle;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerHubClient;
import io.appform.ranger.client.http.UnshardedRangerHttpHubClient;
import io.appform.ranger.common.server.ShardInfo;
import io.appform.ranger.http.model.ServiceNodesResponse;
import io.appform.ranger.http.server.AppConfiguration;
import io.appform.ranger.http.server.config.RangerHttpConfiguration;
import io.appform.ranger.http.server.healthcheck.RangerHttpHealthCheck;
import io.appform.ranger.zk.server.bundle.RangerServerBundle;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpServerBundle
extends RangerServerBundle<ShardInfo, AppConfiguration> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpServerBundle.class);

    protected List<RangerHubClient<ShardInfo>> withHubs(AppConfiguration configuration) {
        RangerHttpConfiguration rangerConfiguration = configuration.getRangerConfiguration();
        return rangerConfiguration.getHttpClientConfigs().stream().map(clientConfig -> UnshardedRangerHttpHubClient.builder().namespace(rangerConfiguration.getNamespace()).mapper(this.getMapper()).clientConfig(clientConfig).nodeRefreshIntervalMs(rangerConfiguration.getNodeRefreshTimeMs()).deserializer(data -> {
            try {
                return (ServiceNodesResponse)this.getMapper().readValue(data, (TypeReference)new TypeReference<ServiceNodesResponse<ShardInfo>>(){});
            }
            catch (IOException e) {
                log.warn("Error parsing node data with value {}", (Object)new String(data));
                return null;
            }
        }).build()).collect(Collectors.toList());
    }

    protected boolean withInitialRotationStatus(AppConfiguration configuration) {
        return configuration.isInitialRotationStatus();
    }

    protected List<HealthCheck> withHealthChecks(AppConfiguration configuration) {
        return ImmutableList.of((Object)((Object)new RangerHttpHealthCheck()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HttpServerBundle() {
    }
}

