/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.http.server.bundle;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerHubClient;
import io.appform.ranger.client.http.UnshardedRangerHttpHubClient;
import io.appform.ranger.common.server.ShardInfo;
import io.appform.ranger.core.finder.serviceregistry.ListBasedServiceRegistry;
import io.appform.ranger.core.model.Deserializer;
import io.appform.ranger.http.model.ServiceNodesResponse;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import io.appform.ranger.http.server.bundle.config.RangerHttpConfiguration;
import io.appform.ranger.http.server.bundle.healthcheck.RangerHttpHealthCheck;
import io.appform.ranger.server.bundle.RangerServerBundle;
import io.dropwizard.Configuration;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class HttpServerBundle<U extends Configuration>
extends RangerServerBundle<ShardInfo, ListBasedServiceRegistry<ShardInfo>, U> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpServerBundle.class);

    protected abstract RangerHttpConfiguration getRangerConfiguration(U var1);

    protected List<RangerHubClient<ShardInfo, ListBasedServiceRegistry<ShardInfo>>> withHubs(U configuration) {
        RangerHttpConfiguration rangerConfiguration = this.getRangerConfiguration(configuration);
        return rangerConfiguration.getHttpClientConfigs().stream().map(clientConfig -> ((UnshardedRangerHttpHubClient.UnshardedRangerHttpHubClientBuilder)((UnshardedRangerHttpHubClient.UnshardedRangerHttpHubClientBuilder)((UnshardedRangerHttpHubClient.UnshardedRangerHttpHubClientBuilder)((UnshardedRangerHttpHubClient.UnshardedRangerHttpHubClientBuilder)((UnshardedRangerHttpHubClient.UnshardedRangerHttpHubClientBuilder)UnshardedRangerHttpHubClient.builder().namespace(rangerConfiguration.getNamespace())).mapper(this.getMapper())).clientConfig(clientConfig)).nodeRefreshTimeMs(rangerConfiguration.getNodeRefreshTimeMs())).deserializer((Deserializer)((HTTPResponseDataDeserializer)data -> {
            try {
                return (ServiceNodesResponse)this.getMapper().readValue(data, (TypeReference)new TypeReference<ServiceNodesResponse<ShardInfo>>(){});
            }
            catch (IOException e) {
                log.warn("Error parsing node data with value {}", (Object)new String(data));
                return null;
            }
        }))).build()).collect(Collectors.toList());
    }

    protected List<HealthCheck> withHealthChecks(U configuration) {
        return ImmutableList.of((Object)((Object)new RangerHttpHealthCheck()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HttpServerBundle() {
    }
}

