/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.AbstractRangerClient;
import io.appform.ranger.core.finder.SimpleUnshardedServiceFinder;
import io.appform.ranger.core.finder.serviceregistry.ListBasedServiceRegistry;
import io.appform.ranger.core.finder.shardselector.ListShardSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.http.HttpServiceFinderBuilders;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import io.appform.ranger.http.servicefinder.HttpUnshardedServiceFinderBuilider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRangerHttpClient<T>
extends AbstractRangerClient<T, ListBasedServiceRegistry<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleRangerHttpClient.class);
    private final String serviceName;
    private final String namespace;
    private final ObjectMapper mapper;
    private final int nodeRefreshIntervalMs;
    private final HttpClientConfig clientConfig;
    private final HTTPResponseDataDeserializer<T> deserializer;
    private SimpleUnshardedServiceFinder<T> serviceFinder;

    public void start() {
        log.info("Starting the service finder");
        Preconditions.checkNotNull((Object)this.mapper, (Object)"Mapper can't be null");
        Preconditions.checkNotNull((Object)this.namespace, (Object)"namespace can't be null");
        Preconditions.checkNotNull(this.deserializer, (Object)"deserializer can't be null");
        this.serviceFinder = ((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)HttpServiceFinderBuilders.httpUnshardedServiceFinderBuilider().withClientConfig(this.clientConfig).withServiceName(this.serviceName)).withNamespace(this.namespace)).withObjectMapper(this.mapper).withNodeRefreshIntervalMs(this.nodeRefreshIntervalMs)).withDeserializer(this.deserializer)).withShardSelector((ShardSelector)new ListShardSelector())).build();
        this.serviceFinder.start();
        log.info("Started the service finder");
    }

    public void stop() {
        log.info("Stopping the service finder");
        this.serviceFinder.stop();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected SimpleRangerHttpClient(SimpleRangerHttpClientBuilder<T, ?, ?> b) {
        super(b);
        this.serviceName = ((SimpleRangerHttpClientBuilder)b).serviceName;
        this.namespace = ((SimpleRangerHttpClientBuilder)b).namespace;
        this.mapper = ((SimpleRangerHttpClientBuilder)b).mapper;
        this.nodeRefreshIntervalMs = ((SimpleRangerHttpClientBuilder)b).nodeRefreshIntervalMs;
        this.clientConfig = ((SimpleRangerHttpClientBuilder)b).clientConfig;
        this.deserializer = ((SimpleRangerHttpClientBuilder)b).deserializer;
        this.serviceFinder = ((SimpleRangerHttpClientBuilder)b).serviceFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> SimpleRangerHttpClientBuilder<T, ?, ?> builder() {
        return new SimpleRangerHttpClientBuilderImpl();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SimpleUnshardedServiceFinder<T> getServiceFinder() {
        return this.serviceFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final class SimpleRangerHttpClientBuilderImpl<T>
    extends SimpleRangerHttpClientBuilder<T, SimpleRangerHttpClient<T>, SimpleRangerHttpClientBuilderImpl<T>> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SimpleRangerHttpClientBuilderImpl() {
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected SimpleRangerHttpClientBuilderImpl<T> self() {
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClient<T> build() {
            return new SimpleRangerHttpClient(this);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static abstract class SimpleRangerHttpClientBuilder<T, C extends SimpleRangerHttpClient<T>, B extends SimpleRangerHttpClientBuilder<T, C, B>>
    extends AbstractRangerClient.AbstractRangerClientBuilder<T, ListBasedServiceRegistry<T>, C, B> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String serviceName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshIntervalMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HttpClientConfig clientConfig;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HTTPResponseDataDeserializer<T> deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SimpleUnshardedServiceFinder<T> serviceFinder;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected abstract B self();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public abstract C build();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B serviceName(String serviceName) {
            this.serviceName = serviceName;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B nodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
            this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B clientConfig(HttpClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B deserializer(HTTPResponseDataDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B serviceFinder(SimpleUnshardedServiceFinder<T> serviceFinder) {
            this.serviceFinder = serviceFinder;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SimpleRangerHttpClient.SimpleRangerHttpClientBuilder(super=" + super.toString() + ", serviceName=" + this.serviceName + ", namespace=" + this.namespace + ", mapper=" + this.mapper + ", nodeRefreshIntervalMs=" + this.nodeRefreshIntervalMs + ", clientConfig=" + this.clientConfig + ", deserializer=" + this.deserializer + ", serviceFinder=" + this.serviceFinder + ")";
        }
    }
}

