/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client.http;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.AbstractRangerHubClient;
import io.appform.ranger.core.finder.nodeselector.RoundRobinServiceNodeSelector;
import io.appform.ranger.core.finder.serviceregistry.MapBasedServiceRegistry;
import io.appform.ranger.core.finder.shardselector.MatchingShardSelector;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.finderhub.ServiceFinderFactory;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import io.appform.ranger.http.servicefinderhub.HttpServiceDataSource;
import io.appform.ranger.http.servicefinderhub.HttpServiceFinderHubBuilder;
import io.appform.ranger.http.servicefinderhub.HttpShardedServiceFinderFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedRangerHttpHubClient<T>
extends AbstractRangerHubClient<T, MapBasedServiceRegistry<T>, HTTPResponseDataDeserializer<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardedRangerHttpHubClient.class);
    private final HttpClientConfig clientConfig;

    protected ServiceDataSource getDataSource() {
        return new HttpServiceDataSource(this.clientConfig, this.getMapper());
    }

    protected ServiceFinderHub<T, MapBasedServiceRegistry<T>> buildHub() {
        return new HttpServiceFinderHubBuilder().withServiceDataSource(this.buildServiceDataSource()).withServiceFinderFactory(this.buildFinderFactory()).withRefreshFrequencyMs((long)this.getNodeRefreshTimeMs()).build();
    }

    protected ServiceFinderFactory<T, MapBasedServiceRegistry<T>> buildFinderFactory() {
        return HttpShardedServiceFinderFactory.builder().httpClientConfig(this.clientConfig).nodeRefreshIntervalMs(this.getNodeRefreshTimeMs()).deserializer((HTTPResponseDataDeserializer)this.getDeserializer()).shardSelector((ShardSelector)new MatchingShardSelector()).nodeSelector((ServiceNodeSelector)new RoundRobinServiceNodeSelector()).mapper(this.getMapper()).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected ShardedRangerHttpHubClient(ShardedRangerHttpHubClientBuilder<T, ?, ?> b) {
        super(b);
        this.clientConfig = ((ShardedRangerHttpHubClientBuilder)b).clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> ShardedRangerHttpHubClientBuilder<T, ?, ?> builder() {
        return new ShardedRangerHttpHubClientBuilderImpl();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final class ShardedRangerHttpHubClientBuilderImpl<T>
    extends ShardedRangerHttpHubClientBuilder<T, ShardedRangerHttpHubClient<T>, ShardedRangerHttpHubClientBuilderImpl<T>> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ShardedRangerHttpHubClientBuilderImpl() {
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected ShardedRangerHttpHubClientBuilderImpl<T> self() {
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ShardedRangerHttpHubClient<T> build() {
            return new ShardedRangerHttpHubClient(this);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static abstract class ShardedRangerHttpHubClientBuilder<T, C extends ShardedRangerHttpHubClient<T>, B extends ShardedRangerHttpHubClientBuilder<T, C, B>>
    extends AbstractRangerHubClient.AbstractRangerHubClientBuilder<T, MapBasedServiceRegistry<T>, HTTPResponseDataDeserializer<T>, C, B> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HttpClientConfig clientConfig;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected abstract B self();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public abstract C build();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B clientConfig(HttpClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return (B)this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ShardedRangerHttpHubClient.ShardedRangerHttpHubClientBuilder(super=" + super.toString() + ", clientConfig=" + this.clientConfig + ")";
        }
    }
}

