/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.AbstractRangerHubClient;
import io.appform.ranger.core.finder.nodeselector.RoundRobinServiceNodeSelector;
import io.appform.ranger.core.finder.serviceregistry.ListBasedServiceRegistry;
import io.appform.ranger.core.finder.shardselector.ListShardSelector;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.finderhub.ServiceFinderFactory;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.finderhub.StaticDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import io.appform.ranger.http.servicefinderhub.HttpServiceDataSource;
import io.appform.ranger.http.servicefinderhub.HttpServiceFinderHubBuilder;
import io.appform.ranger.http.servicefinderhub.HttpUnshardedServiceFinderFactory;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnshardedRangerHttpHubClient<T>
extends AbstractRangerHubClient<T, ListBasedServiceRegistry<T>, HTTPResponseDataDeserializer<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnshardedRangerHttpHubClient.class);
    private final Set<Service> services;
    private final HttpClientConfig clientConfig;

    public UnshardedRangerHttpHubClient(String namespace, ObjectMapper mapper, int nodeRefreshIntervalMs, Predicate<T> criteria, HTTPResponseDataDeserializer<T> deserializer, HttpClientConfig clientConfig, Set<Service> services, boolean alwaysUseInitialCriteria) {
        super(namespace, mapper, nodeRefreshIntervalMs, criteria, deserializer, alwaysUseInitialCriteria);
        this.clientConfig = clientConfig;
        this.services = null != services ? services : Collections.emptySet();
    }

    protected ServiceFinderHub<T, ListBasedServiceRegistry<T>> buildHub() {
        return new HttpServiceFinderHubBuilder().withServiceDataSource(this.buildServiceDataSource()).withServiceFinderFactory(this.buildFinderFactory()).withRefreshFrequencyMs((long)this.getNodeRefreshTimeMs()).build();
    }

    protected ServiceDataSource buildServiceDataSource() {
        return !this.services.isEmpty() ? new StaticDataSource(this.services) : new HttpServiceDataSource(this.clientConfig, this.getMapper());
    }

    protected ServiceFinderFactory<T, ListBasedServiceRegistry<T>> buildFinderFactory() {
        return HttpUnshardedServiceFinderFactory.builder().httpClientConfig(this.clientConfig).nodeRefreshIntervalMs(this.getNodeRefreshTimeMs()).deserializer((HTTPResponseDataDeserializer)this.getDeserializer()).shardSelector((ShardSelector)new ListShardSelector()).nodeSelector((ServiceNodeSelector)new RoundRobinServiceNodeSelector()).mapper(this.getMapper()).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> UnshardedRangerHttpHubClientBuilder<T> builder() {
        return new UnshardedRangerHttpHubClientBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class UnshardedRangerHttpHubClientBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshIntervalMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Predicate<T> criteria;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HTTPResponseDataDeserializer<T> deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HttpClientConfig clientConfig;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Set<Service> services;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean alwaysUseInitialCriteria;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        UnshardedRangerHttpHubClientBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClientBuilder<T> namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClientBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClientBuilder<T> nodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
            this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClientBuilder<T> criteria(Predicate<T> criteria) {
            this.criteria = criteria;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClientBuilder<T> deserializer(HTTPResponseDataDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClientBuilder<T> clientConfig(HttpClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClientBuilder<T> services(Set<Service> services) {
            this.services = services;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClientBuilder<T> alwaysUseInitialCriteria(boolean alwaysUseInitialCriteria) {
            this.alwaysUseInitialCriteria = alwaysUseInitialCriteria;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UnshardedRangerHttpHubClient<T> build() {
            return new UnshardedRangerHttpHubClient<T>(this.namespace, this.mapper, this.nodeRefreshIntervalMs, this.criteria, this.deserializer, this.clientConfig, this.services, this.alwaysUseInitialCriteria);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "UnshardedRangerHttpHubClient.UnshardedRangerHttpHubClientBuilder(namespace=" + this.namespace + ", mapper=" + this.mapper + ", nodeRefreshIntervalMs=" + this.nodeRefreshIntervalMs + ", criteria=" + this.criteria + ", deserializer=" + this.deserializer + ", clientConfig=" + this.clientConfig + ", services=" + this.services + ", alwaysUseInitialCriteria=" + this.alwaysUseInitialCriteria + ")";
        }
    }
}

