/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.AbstractRangerClient;
import io.appform.ranger.core.finder.SimpleUnshardedServiceFinder;
import io.appform.ranger.core.finder.serviceregistry.ListBasedServiceRegistry;
import io.appform.ranger.core.finder.shardselector.ListShardSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.http.HttpServiceFinderBuilders;
import io.appform.ranger.http.config.HttpClientConfig;
import io.appform.ranger.http.serde.HTTPResponseDataDeserializer;
import io.appform.ranger.http.servicefinder.HttpUnshardedServiceFinderBuilider;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRangerHttpClient<T>
extends AbstractRangerClient<T, ListBasedServiceRegistry<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleRangerHttpClient.class);
    private final SimpleUnshardedServiceFinder<T> serviceFinder;

    public SimpleRangerHttpClient(String namespace, String serviceName, ObjectMapper mapper, int nodeRefreshIntervalMs, HttpClientConfig clientConfig, Predicate<T> initialCriteria, HTTPResponseDataDeserializer<T> deserializer, boolean alwaysUseInitialCriteria) {
        super(initialCriteria, alwaysUseInitialCriteria);
        Preconditions.checkNotNull((Object)mapper, (Object)"Mapper can't be null");
        Preconditions.checkNotNull((Object)namespace, (Object)"namespace can't be null");
        Preconditions.checkNotNull(deserializer, (Object)"deserializer can't be null");
        this.serviceFinder = ((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)((HttpUnshardedServiceFinderBuilider)HttpServiceFinderBuilders.httpUnshardedServiceFinderBuilider().withClientConfig(clientConfig).withServiceName(serviceName)).withNamespace(namespace)).withObjectMapper(mapper).withNodeRefreshIntervalMs(nodeRefreshIntervalMs)).withDeserializer(deserializer)).withShardSelector((ShardSelector)new ListShardSelector())).build();
    }

    public void start() {
        log.info("Starting the service finder");
        this.serviceFinder.start();
    }

    public void stop() {
        log.info("Stopping the service finder");
        this.serviceFinder.stop();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> SimpleRangerHttpClientBuilder<T> builder() {
        return new SimpleRangerHttpClientBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SimpleUnshardedServiceFinder<T> getServiceFinder() {
        return this.serviceFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SimpleRangerHttpClientBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String serviceName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshIntervalMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HttpClientConfig clientConfig;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Predicate<T> initialCriteria;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HTTPResponseDataDeserializer<T> deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean alwaysUseInitialCriteria;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SimpleRangerHttpClientBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClientBuilder<T> namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClientBuilder<T> serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClientBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClientBuilder<T> nodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
            this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClientBuilder<T> clientConfig(HttpClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClientBuilder<T> initialCriteria(Predicate<T> initialCriteria) {
            this.initialCriteria = initialCriteria;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClientBuilder<T> deserializer(HTTPResponseDataDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClientBuilder<T> alwaysUseInitialCriteria(boolean alwaysUseInitialCriteria) {
            this.alwaysUseInitialCriteria = alwaysUseInitialCriteria;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SimpleRangerHttpClient<T> build() {
            return new SimpleRangerHttpClient<T>(this.namespace, this.serviceName, this.mapper, this.nodeRefreshIntervalMs, this.clientConfig, this.initialCriteria, this.deserializer, this.alwaysUseInitialCriteria);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SimpleRangerHttpClient.SimpleRangerHttpClientBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", mapper=" + this.mapper + ", nodeRefreshIntervalMs=" + this.nodeRefreshIntervalMs + ", clientConfig=" + this.clientConfig + ", initialCriteria=" + this.initialCriteria + ", deserializer=" + this.deserializer + ", alwaysUseInitialCriteria=" + this.alwaysUseInitialCriteria + ")";
        }
    }
}

