/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.util;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class ConfigurationUtils {
    public static String resolveNonEmptyPublishedHost(String publishedHost) throws UnknownHostException {
        if (Strings.isNullOrEmpty((String)publishedHost) || publishedHost.equals("__DEFAULT_SERVICE_HOST")) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        return publishedHost;
    }

    public static Set<String> resolveZookeeperHosts(String zkHostString) {
        return Arrays.stream(zkHostString.split(",")).map(zkHostPort -> zkHostPort.split(":")[0]).map(zkHostPath -> zkHostPath.split("/")[0]).collect(Collectors.toSet());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ConfigurationUtils() {
    }
}

